function displaySelectedImage(event, elementId) {
    const selectedImage = document.getElementById(elementId);
    const fileInput = event.target;

    if (fileInput.files && fileInput.files[0]) {
        const reader = new FileReader();

        reader.onload = function(e) {
            selectedImage.src = e.target.result;
        };

        reader.readAsDataURL(fileInput.files[0]);
    }
}


// Slider Script 

let currentSlide = 0;
const slides = document.querySelector('.slides');
const totalSlides = slides.children.length;

function updateSlide() {
    slides.style.transform = `translateX(-${currentSlide * 100}%)`;
}

function nextSlide() {
    currentSlide = (currentSlide + 1) % totalSlides;
    updateSlide();
}

function prevSlide() {
    currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
    updateSlide();
}
              

// Progress Circle Script 

const progressValue = 80;

function updateProgress(percent) {
    const circle = document.querySelector('.circle-fg');
    const radius = circle.r.baseVal.value;
    const circumference = 2 * Math.PI * radius;
    const offset = circumference - (percent / 100) * circumference;
    circle.style.strokeDashoffset = offset;

    const percentageText = document.getElementById('percentage');
    percentageText.innerText = `${percent}%`;
}
updateProgress(progressValue);



//   Age Checking 

function closeForm(){
    document.getElementById('contactForm').style.display = 'none'; 
    document.getElementById('overlay').style.display = 'none'; 
}

function checkAge() {
    // const birthdate = new Date(document.getElementById("birthdate").value);
    // const today = new Date();
    // const age = today.getFullYear() - birthdate.getFullYear();
    // const monthDifference = today.getMonth() - birthdate.getMonth();
    
    // if (monthDifference < 0 || (monthDifference === 0 && today.getDate() < birthdate.getDate())) {
    //     age--;
    // }

    // if (age >= 16) {
    //     document.getElementById("verified").style.display = "inline-block"; 
    //     document.getElementById("message").style.display = "none"; 

    //     setTimeout(function() {
    //         document.getElementById('contactForm').style.display = 'none'; 
    //         document.getElementById('overlay').style.display = 'none'; 
    //     }, 1000); 
    // } else {
    //     document.getElementById("verified").style.display = "none"; 
    //     document.getElementById("message").style.display = "inline-block"; 
    // }
}

window.onload = function() {
    document.getElementById('contactForm').style.display = 'block'; 
    document.getElementById('overlay').style.display = 'block'; 
    
};

